/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.obj;

import com.lycanitesmobs.client.obj.Vertex;
import java.nio.ByteBuffer;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL15;

public class Mesh {
    public int[] indices;
    public Vertex[] vertices;
    public Vector3f[] normals;
    private int vbo = -1;

    public int getVbo() {
        Vector3f normal;
        if (this.vbo != -1) {
            return this.vbo;
        }
        if (this.normals == null) {
            this.normals = new Vector3f[this.indices.length];
            for (int i = 0; i < this.normals.length / 3; ++i) {
                Vector3f v1 = this.vertices[this.indices[i * 3]].getPos();
                Vector3f v2 = this.vertices[this.indices[i * 3 + 1]].getPos();
                Vector3f v3 = this.vertices[this.indices[i * 3 + 2]].getPos();
                this.normals[i * 3] = normal = Mesh.calcNormal(v1, v2, v3);
                this.normals[i * 3 + 1] = normal;
                this.normals[i * 3 + 2] = normal;
            }
        }
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tesselator.func_178180_c();
        bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181710_j);
        for (int i = 0; i < this.indices.length; ++i) {
            Vertex vertex = this.vertices[this.indices[i]];
            normal = this.normals[i];
            bufferBuilder.func_181662_b((double)vertex.getPos().x, (double)vertex.getPos().y, (double)vertex.getPos().z);
            bufferBuilder.func_187315_a((double)vertex.getTexCoords().x, (double)(1.0f - vertex.getTexCoords().y));
            bufferBuilder.func_181663_c(normal.x, normal.y, normal.z);
            bufferBuilder.func_181675_d();
        }
        bufferBuilder.func_178977_d();
        this.vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (ByteBuffer)bufferBuilder.func_178966_f(), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        bufferBuilder.func_178965_a();
        return this.vbo;
    }

    private static Vector3f calcNormal(Vector3f v1, Vector3f v2, Vector3f v3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
        Vector3f calV = new Vector3f(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z);
        output.x = calU.y * calV.z - calU.z * calV.y;
        output.y = calU.z * calV.x - calU.x * calV.z;
        output.z = calU.x * calV.y - calU.y * calV.x;
        output.normalize();
        return output;
    }

    public void delete() {
        GL15.glDeleteBuffers((int)this.vbo);
        this.vbo = -1;
    }
}

